#if !defined __UNIOCTL_H
#define __UNIOCTL_H

// Filename: Unioctl.H
//
// Description:
//   Include file for Universal port I/O provider,
//   define the Unio IOCTL codes.
//
// A.Kolegov (NIIATT) 30.08.1996


// Device type in the "User Defined" range
#define UNIO_TYPE 40000


// The IOCTL function codes from 0x800 to 0xFFF are for customer use

#define IOCTL_UNIO_READ_PORT_UCHAR \
    CTL_CODE( UNIO_TYPE, 0x900, METHOD_BUFFERED, FILE_READ_ACCESS )

#define IOCTL_UNIO_READ_PORT_USHORT \
    CTL_CODE( UNIO_TYPE, 0x901, METHOD_BUFFERED, FILE_READ_ACCESS )

#define IOCTL_UNIO_READ_PORT_ULONG \
    CTL_CODE( UNIO_TYPE, 0x902, METHOD_BUFFERED, FILE_READ_ACCESS )

#define IOCTL_UNIO_WRITE_PORT_UCHAR \
    CTL_CODE( UNIO_TYPE, 0x910, METHOD_BUFFERED, FILE_WRITE_ACCESS )

#define IOCTL_UNIO_WRITE_PORT_USHORT \
    CTL_CODE( UNIO_TYPE, 0x911, METHOD_BUFFERED, FILE_WRITE_ACCESS )

#define IOCTL_UNIO_WRITE_PORT_ULONG \
    CTL_CODE( UNIO_TYPE, 0x912, METHOD_BUFFERED, FILE_WRITE_ACCESS )

#define IOCTL_UNIO_GET_PARAMETERS \
    CTL_CODE( UNIO_TYPE, 0x920, METHOD_BUFFERED, FILE_READ_ACCESS )

typedef struct _PORT_IO {
  ULONG    PortNumber;     // Port # to write to
  union {                  // Data to be output to port
    ULONG  LongData;
    USHORT ShortData;
    UCHAR  CharData;
  };
} PORT_IO;

#endif //__UNIOCTL_H
